/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.stalactite.engine.BeanKeyQueryMapper;
import org.codefilarete.stalactite.engine.BeanPropertyQueryMapper;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnReader;
import org.codefilarete.stalactite.sql.result.MultipleColumnsReader;
import org.codefilarete.stalactite.sql.result.ResultSetRowAssembler;
import org.codefilarete.stalactite.sql.result.ResultSetRowTransformer;
import org.codefilarete.stalactite.sql.result.SingleColumnReader;
import org.codefilarete.stalactite.sql.result.WholeResultSetTransformer;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Converter;
import org.codefilarete.tool.function.SerializableTriFunction;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableBiFunction;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public class QueryMapper<C>
implements BeanKeyQueryMapper<C>,
BeanPropertyQueryMapper<C> {
    private static final MethodReferenceCapturer METHOD_REFERENCE_CAPTURER = new MethodReferenceCapturer();
    private final MethodReferenceCapturer methodReferenceCapturer;
    private final Class<C> rootBeanType;
    private final SQLBuilder sqlBuilder;
    private final ColumnBinderRegistry columnBinderRegistry;
    private final Map<String, ParameterBinder<?>> sqlParameterBinders = new HashMap();
    private final Map<String, Object> sqlArguments = new HashMap<String, Object>();
    private WholeResultSetTransformer<C, ?> rootTransformer;
    private final QueryMapping<C, ?> mapping = new QueryMapping();
    private final ReadOperationFactory readOperationFactory;
    private final Map<Selectable<?>, String> aliases = new HashMap();

    public QueryMapper(Class<C> rootBeanType, CharSequence sqlBuilder, ColumnBinderRegistry columnBinderRegistry, ReadOperationFactory readOperationFactory) {
        this(rootBeanType, sqlBuilder, columnBinderRegistry, METHOD_REFERENCE_CAPTURER, readOperationFactory);
    }

    public QueryMapper(Class<C> rootBeanType, SQLBuilder sqlBuilder, ColumnBinderRegistry columnBinderRegistry, ReadOperationFactory readOperationFactory) {
        this(rootBeanType, sqlBuilder, columnBinderRegistry, METHOD_REFERENCE_CAPTURER, readOperationFactory);
    }

    public QueryMapper(Class<C> rootBeanType, CharSequence sqlBuilder, ColumnBinderRegistry columnBinderRegistry, MethodReferenceCapturer methodReferenceCapturer, ReadOperationFactory readOperationFactory) {
        this(rootBeanType, () -> sqlBuilder, columnBinderRegistry, methodReferenceCapturer, readOperationFactory);
    }

    public QueryMapper(Class<C> rootBeanType, SQLBuilder sqlBuilder, ColumnBinderRegistry columnBinderRegistry, MethodReferenceCapturer methodReferenceCapturer, ReadOperationFactory readOperationFactory) {
        this.rootBeanType = rootBeanType;
        this.sqlBuilder = sqlBuilder;
        this.columnBinderRegistry = columnBinderRegistry;
        this.methodReferenceCapturer = methodReferenceCapturer;
        this.readOperationFactory = readOperationFactory;
    }

    public void setColumnAliases(Map<Selectable<?>, String> aliases) {
        this.aliases.putAll(aliases);
    }

    @Override
    public QueryMapper<C> mapKey(SerializableSupplier<C> factory) {
        this.rootTransformer = new WholeResultSetTransformer(this.rootBeanType, factory);
        return this;
    }

    @Override
    public <I> QueryMapper<C> mapKey(SerializableFunction<I, C> factory, String columnName) {
        MethodReferenceCapturer methodReferenceCapturer = new MethodReferenceCapturer();
        Executable executable = methodReferenceCapturer.findExecutable(factory);
        this.rootTransformer = this.buildSingleColumnKeyTransformer(new ColumnDefinition(columnName, executable.getParameterTypes()[0]), factory);
        return this;
    }

    @Override
    public <I, J> QueryMapper<C> mapKey(SerializableBiFunction<I, J, C> factory, String column1, String column2) {
        MethodReferenceCapturer methodReferenceCapturer = new MethodReferenceCapturer();
        Executable executable = methodReferenceCapturer.findExecutable(factory);
        SerializableFunction & Serializable constructorInvokation = (SerializableFunction & Serializable)args -> factory.apply(args[0], args[1]);
        this.rootTransformer = this.buildComposedKeyTransformer(Arrays.asSet((Object[])new Column[]{new ColumnDefinition(column1, executable.getParameterTypes()[0]), new ColumnDefinition(column2, executable.getParameterTypes()[1])}), constructorInvokation);
        return this;
    }

    @Override
    public <I, J, K> QueryMapper<C> mapKey(SerializableTriFunction<I, J, K, C> factory, String column1, String column2, String column3) {
        MethodReferenceCapturer methodReferenceCapturer = new MethodReferenceCapturer();
        Executable executable = methodReferenceCapturer.findExecutable(factory);
        SerializableFunction & Serializable constructorInvokation = (SerializableFunction & Serializable)args -> factory.apply(args[0], args[1], args[2]);
        this.rootTransformer = this.buildComposedKeyTransformer(Arrays.asSet((Object[])new Column[]{new ColumnDefinition(column1, executable.getParameterTypes()[0]), new ColumnDefinition(column2, executable.getParameterTypes()[1]), new ColumnDefinition(column3, executable.getParameterTypes()[2])}), constructorInvokation);
        return this;
    }

    @Override
    public <I> QueryMapper<C> mapKey(SerializableFunction<I, C> factory, String columnName, Class<I> columnType) {
        this.rootTransformer = this.buildSingleColumnKeyTransformer(new ColumnDefinition(columnName, columnType), factory);
        return this;
    }

    @Override
    public <I, J> QueryMapper<C> mapKey(SerializableBiFunction<I, J, C> factory, String column1Name, Class<I> column1Type, String column2Name, Class<J> column2Type) {
        SerializableFunction & Serializable constructorInvokation = (SerializableFunction & Serializable)args -> factory.apply(args[0], args[1]);
        this.rootTransformer = this.buildComposedKeyTransformer(Arrays.asSet((Object[])new Column[]{new ColumnDefinition(column1Name, column1Type), new ColumnDefinition(column2Name, column2Type)}), constructorInvokation);
        return this;
    }

    @Override
    public <I, J, K> QueryMapper<C> mapKey(SerializableTriFunction<I, J, K, C> factory, String column1Name, Class<I> column1Type, String column2Name, Class<J> column2Type, String column3Name, Class<K> column3Type) {
        SerializableFunction & Serializable constructorInvokation = (SerializableFunction & Serializable)args -> factory.apply(args[0], args[1], args[2]);
        this.rootTransformer = this.buildComposedKeyTransformer(Arrays.asSet((Object[])new Column[]{new ColumnDefinition(column1Name, column1Type), new ColumnDefinition(column2Name, column2Type), new ColumnDefinition(column3Name, column3Type)}), constructorInvokation);
        return this;
    }

    @Override
    public <I> QueryMapper<C> mapKey(SerializableFunction<I, C> factory, Selectable<I> column) {
        this.rootTransformer = this.buildSingleColumnKeyTransformer(new ColumnWrapper(column), factory);
        return this;
    }

    @Override
    public <I, J> QueryMapper<C> mapKey(SerializableBiFunction<I, J, C> factory, Selectable<I> column1, Selectable<J> column2) {
        SerializableFunction & Serializable constructorInvokation = (SerializableFunction & Serializable)args -> factory.apply(args[0], args[1]);
        this.rootTransformer = this.buildComposedKeyTransformer(Arrays.asSet((Object[])new Column[]{new ColumnWrapper(column1), new ColumnWrapper(column2)}), constructorInvokation);
        return this;
    }

    @Override
    public <I, J, K> QueryMapper<C> mapKey(SerializableTriFunction<I, J, K, C> factory, Selectable<I> column1, Selectable<J> column2, Selectable<K> column3) {
        SerializableFunction & Serializable constructorInvokation = (SerializableFunction & Serializable)args -> factory.apply(args[0], args[1], args[2]);
        this.rootTransformer = this.buildComposedKeyTransformer(Arrays.asSet((Object[])new Column[]{new ColumnWrapper(column1), new ColumnWrapper(column2), new ColumnWrapper(column3)}), constructorInvokation);
        return this;
    }

    @Override
    public <I> QueryMapper<I> mapKey(String columnName, Class<I> columnType) {
        this.rootTransformer = this.buildSingleColumnKeyTransformer(new ColumnDefinition(columnName, columnType), SerializableFunction.identity());
        return this;
    }

    @Override
    public <I> QueryMapper<C> map(String columnName, BiConsumer<C, I> setter, Class<I> columnType) {
        this.map(new ColumnMapping<C, I>(columnName, setter, columnType));
        return this;
    }

    @Override
    public <I, J> QueryMapper<C> map(String columnName, SerializableBiConsumer<C, J> setter, Class<I> columnType, Converter<I, J> converter) {
        return this.map(columnName, (c, i) -> setter.accept(c, converter.convert(i)), (Class)columnType);
    }

    @Override
    public <I> QueryMapper<C> map(String columnName, SerializableBiConsumer<C, I> setter) {
        this.map(columnName, (BiConsumer)setter, (Class)this.giveColumnType(setter));
        return this;
    }

    @Override
    public <I, J> QueryMapper<C> map(String columnName, SerializableBiConsumer<C, J> setter, Converter<I, J> converter) {
        Method method = this.methodReferenceCapturer.findMethod(setter);
        Class<?> aClass = method.getParameterTypes()[0];
        return this.map(columnName, (c, i) -> setter.accept(c, converter.convert(i)), aClass);
    }

    @Override
    public <I> QueryMapper<C> map(Selectable<I> column, BiConsumer<C, I> setter) {
        this.map(new ColumnMapping<C, I>(column, setter));
        return this;
    }

    @Override
    public <I, J> QueryMapper<C> map(Selectable<I> column, BiConsumer<C, J> setter, Converter<I, J> converter) {
        return this.map((Selectable)column, (T c, U i) -> setter.accept(c, converter.convert(i)));
    }

    private <I> void map(ColumnMapping<C, I> columnMapping) {
        this.mapping.add(columnMapping);
    }

    @Override
    public QueryMapper<C> map(ResultSetRowAssembler<C> assembler) {
        return this.map((ResultSetRowAssembler)assembler, WholeResultSetTransformer.AssemblyPolicy.ON_EACH_ROW);
    }

    @Override
    public QueryMapper<C> map(ResultSetRowAssembler<C> assembler, WholeResultSetTransformer.AssemblyPolicy assemblyPolicy) {
        this.mapping.add(assembler, assemblyPolicy);
        return this;
    }

    @Override
    public <K, V> QueryMapper<C> map(BeanRelationFixer<C, V> combiner, ResultSetRowTransformer<V, K> relatedBeanCreator) {
        this.mapping.add(combiner, relatedBeanCreator);
        return this;
    }

    public Set<C> execute(ConnectionProvider connectionProvider) {
        return (Set)this.execute(connectionProvider, Accumulators.toSet());
    }

    public <R> R execute(ConnectionProvider connectionProvider, Accumulator<C, ?, R> accumulator) {
        WholeResultSetTransformer transformerToUse = this.rootTransformer == null ? new WholeResultSetTransformer(this.rootBeanType, (SerializableSupplier & Serializable)() -> Reflections.newInstance(this.rootBeanType)) : this.rootTransformer;
        this.mapping.applyTo(transformerToUse);
        StringParamedSQL parameterizedSQL = new StringParamedSQL(this.sqlBuilder.toSQL().toString(), this.sqlParameterBinders);
        parameterizedSQL.setValues(this.sqlArguments);
        try (ReadOperation readOperation = this.readOperationFactory.createInstance(parameterizedSQL, connectionProvider);){
            Object object = transformerToUse.transformAll(readOperation.execute(), accumulator);
            return (R)object;
        }
    }

    private <I, O> WholeResultSetTransformer<O, I> buildSingleColumnKeyTransformer(Column<I> keyColumn, SerializableFunction<I, O> beanFactory) {
        return new WholeResultSetTransformer(this.rootBeanType, keyColumn.getName(), keyColumn.getBinder(), beanFactory);
    }

    private WholeResultSetTransformer<C, Object[]> buildComposedKeyTransformer(Set<Column> columns, SerializableFunction<Object[], C> beanFactory) {
        HashMap computedAliases = new HashMap();
        Set columnReaders = (Set)Iterables.collect(columns, c -> {
            ParameterBinder reader = c.getBinder();
            String alias = c instanceof ColumnWrapper ? (String)Objects.preventNull((Object)this.aliases.get(((ColumnWrapper)c).getColumn()), (Object)c.getName()) : c.getName();
            computedAliases.put(c, alias);
            return new SingleColumnReader(alias, reader);
        }, HashSet::new);
        MultipleColumnsReader multipleColumnsReader = new MultipleColumnsReader(columnReaders, resultSetRow -> {
            Object[] constructorArgs = new Object[columns.size()];
            int i = 0;
            for (Column column : columns) {
                constructorArgs[i++] = resultSetRow.get(computedAliases.get(column));
            }
            return constructorArgs;
        });
        ResultSetRowTransformer resultSetRowConverter = new ResultSetRowTransformer(this.rootBeanType, (ColumnReader)multipleColumnsReader, beanFactory);
        return new WholeResultSetTransformer(resultSetRowConverter);
    }

    private <I> Class<I> giveColumnType(SerializableBiConsumer<C, I> setter) {
        Method method = this.methodReferenceCapturer.findMethod(setter);
        return (Class)Arrays.last((Object[])method.getParameterTypes());
    }

    @Override
    public QueryMapper<C> set(String paramName, Object value) {
        return this.set(paramName, value, (Class)(value == null ? null : value.getClass()));
    }

    @Override
    public <O> QueryMapper<C> set(String paramName, O value, Class<? super O> valueType) {
        ParameterBinder parameterBinder;
        if (value == null) {
            parameterBinder = NullAwareParameterBinder.ALWAYS_SET_NULL_INSTANCE;
        } else {
            if (value.getClass().isArray()) {
                valueType = (Class<?>)Iterables.first((Object[])((Object[])value));
            } else if (Iterable.class.isAssignableFrom(value.getClass())) {
                valueType = Iterables.first((Iterable)((Iterable)value)).getClass();
            }
            parameterBinder = this.columnBinderRegistry.getBinder(valueType);
        }
        this.sqlParameterBinders.put(paramName, parameterBinder);
        this.sqlArguments.put(paramName, value);
        return this;
    }

    @Override
    public <O> QueryMapper<C> set(String paramName, Iterable<O> value, Class<? super O> valueType) {
        this.sqlParameterBinders.put(paramName, value == null ? NullAwareParameterBinder.ALWAYS_SET_NULL_INSTANCE : this.columnBinderRegistry.getBinder(valueType));
        this.sqlArguments.put(paramName, value);
        return this;
    }

    private static class QueryMapping<C, I> {
        private final List<Mapping> mappings = new ArrayList<Mapping>(10);

        private QueryMapping() {
        }

        public void add(org.codefilarete.stalactite.engine.QueryMapper$ColumnMapping<C, I> columnMapping) {
            this.mappings.add(new ColumnMapping(columnMapping));
        }

        public void add(ResultSetRowAssembler<C> assembler, WholeResultSetTransformer.AssemblyPolicy assemblyPolicy) {
            this.mappings.add(new AssemblerMapping(assembler, assemblyPolicy));
        }

        public <K, V> void add(BeanRelationFixer<K, V> combiner, ResultSetRowTransformer<V, K> relatedBeanCreator) {
            this.mappings.add(new RelationMapping(combiner, relatedBeanCreator));
        }

        public void applyTo(WholeResultSetTransformer<C, I> target) {
            this.mappings.forEach(m -> {
                if (m instanceof ColumnMapping) {
                    org.codefilarete.stalactite.engine.QueryMapper$ColumnMapping columnMapping = ((ColumnMapping)m).columnMapping;
                    target.add(columnMapping.getColumn().getName(), columnMapping.getColumn().getBinder(), columnMapping.getSetter());
                } else if (m instanceof AssemblerMapping) {
                    AssemblerMapping assemblerMapping = (AssemblerMapping)m;
                    target.add(assemblerMapping.assembler, assemblerMapping.policy);
                } else if (m instanceof RelationMapping) {
                    RelationMapping relationMapping = (RelationMapping)m;
                    target.add((arg_0, arg_1) -> ((BeanRelationFixer)relationMapping.combiner).apply(arg_0, arg_1), relationMapping.relatedBeanCreator);
                }
            });
        }

        private static class RelationMapping
        implements Mapping {
            private final BeanRelationFixer combiner;
            private final ResultSetRowTransformer relatedBeanCreator;

            private RelationMapping(BeanRelationFixer combiner, ResultSetRowTransformer relatedBeanCreator) {
                this.combiner = combiner;
                this.relatedBeanCreator = relatedBeanCreator;
            }
        }

        private static class AssemblerMapping
        implements Mapping {
            private final ResultSetRowAssembler assembler;
            private final WholeResultSetTransformer.AssemblyPolicy policy;

            private AssemblerMapping(ResultSetRowAssembler assembler, WholeResultSetTransformer.AssemblyPolicy policy) {
                this.assembler = assembler;
                this.policy = policy;
            }
        }

        private static class ColumnMapping
        implements Mapping {
            private final org.codefilarete.stalactite.engine.QueryMapper$ColumnMapping columnMapping;

            private ColumnMapping(org.codefilarete.stalactite.engine.QueryMapper$ColumnMapping columnMapping) {
                this.columnMapping = columnMapping;
            }
        }

        private static interface Mapping {
        }
    }

    private class ColumnMapping<T, I> {
        private final Column<I> column;
        private final BiConsumer<T, I> setter;

        public ColumnMapping(String columnName, BiConsumer<T, I> setter, Class<I> columnType) {
            this.column = new ColumnDefinition<I>(columnName, columnType);
            this.setter = setter;
        }

        public ColumnMapping(Selectable<I> column, BiConsumer<T, I> setter) {
            this.column = new ColumnWrapper<I>(column);
            this.setter = setter;
        }

        public Column<I> getColumn() {
            return this.column;
        }

        public BiConsumer<T, I> getSetter() {
            return this.setter;
        }
    }

    private class ColumnWrapper<T>
    implements Column<T> {
        private final Selectable<T> column;

        private ColumnWrapper(Selectable<T> column) {
            this.column = column;
        }

        @Override
        public String getName() {
            return this.column.getExpression();
        }

        @Override
        public ParameterBinder<T> getBinder() {
            if (this.column instanceof org.codefilarete.stalactite.sql.ddl.structure.Column) {
                return QueryMapper.this.columnBinderRegistry.getBinder((org.codefilarete.stalactite.sql.ddl.structure.Column)this.column);
            }
            return QueryMapper.this.columnBinderRegistry.getBinder(this.column.getJavaType());
        }

        public Selectable<T> getColumn() {
            return this.column;
        }
    }

    private class ColumnDefinition<T>
    implements Column<T> {
        private final String name;
        private final Class<T> valueType;

        private ColumnDefinition(String name, Class<T> valueType) {
            this.name = name;
            this.valueType = valueType;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ParameterBinder<T> getBinder() {
            return QueryMapper.this.columnBinderRegistry.getBinder(this.valueType);
        }
    }

    private static interface Column<T> {
        public String getName();

        public ParameterBinder<T> getBinder();
    }
}

